# MySQL ile Kurulum - Hızlı Başlangıç

## ✅ Sistem MySQL için Hazır!

Sistem zaten MySQL kullanacak şekilde yapılandırılmış. Sadece birkaç adım:

## 🚀 Hızlı Kurulum

### 1. MySQL Veritabanı Oluşturun

MySQL'e bağlanın:
```bash
mysql -u root -p
```

Veritabanını oluşturun:
```sql
CREATE DATABASE ticket_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
EXIT;
```

### 2. .env Dosyasını Düzenleyin

Proje klasöründe `.env` dosyası oluşturun (yoksa):

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=ticket_system
DB_USERNAME=root
DB_PASSWORD=sizin_mysql_şifreniz
```

**Not:** Şifre yoksa `DB_PASSWORD=` boş bırakın.

### 3. Kurulum Komutlarını Çalıştırın

```bash
# Bağımlılıkları yükle
composer install
npm install

# Uygulama anahtarı
php artisan key:generate

# Veritabanı tablolarını oluştur
php artisan migrate

# (Opsiyonel) Varsayılan kullanıcılar
php artisan db:seed

# Storage link
php artisan storage:link
```

### 4. Sunucuyu Başlatın

**Terminal 1:**
```bash
php artisan serve
```

**Terminal 2:**
```bash
npm run dev
```

Tarayıcıda: **http://localhost:8000**

## 📋 Varsayılan Giriş Bilgileri (Seeder çalıştırıldıysa)

- **Admin:** admin@example.com / password
- **Kullanıcı:** user@example.com / password

## 🔧 Otomatik Kurulum Scripti

Daha kolay kurulum için `setup.sh` scriptini kullanabilirsiniz:

```bash
./setup.sh
```

Script size adım adım rehberlik edecek.

## ❓ Sık Karşılaşılan Sorunlar

### "Access denied for user" Hatası
- `.env` dosyasındaki `DB_USERNAME` ve `DB_PASSWORD` değerlerini kontrol edin
- MySQL kullanıcınızın gerekli yetkilere sahip olduğundan emin olun

### "Unknown database" Hatası
- Veritabanının oluşturulduğundan emin olun
- `.env` dosyasındaki `DB_DATABASE` adını kontrol edin

### MySQL Servisi Çalışmıyor
**macOS:**
```bash
brew services start mysql
```

**Linux:**
```bash
sudo systemctl start mysql
```

**Windows:**
- Services panelinden MySQL'i başlatın

## 📚 Detaylı Kurulum

Daha detaylı bilgi için `INSTALLATION.md` dosyasına bakın.

